//
//  GSLayer_Drawing.h
//  Glyphs
//
//  Created by Georg Seifert on 21.09.10.
//  Copyright 2010 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <GlyphsCore/GSLayer.h>

typedef NS_ENUM(NSInteger, GSLayerExtraInfoDrawing) {
	GSLayerExtraInfoDrawingCustomInfo = 1 << 0,
	GSLayerExtraInfoDrawingMetricsKeysState = 1 << 1,
};

@interface GSLayer (Drawing)

- (void)drawInFrame:(NSRect)frame;
- (void)drawInFrame:(NSRect)frame color:(NSColor *)color metrics:(GSGlyphMetrics)metrics;
- (void)drawInFrame:(NSRect)frame color:(NSColor *)color metrics:(GSGlyphMetrics)metrics scale:(CGFloat)scale;
- (void)drawExtraInfoInFrame:(NSRect)frame options:(GSLayerExtraInfoDrawing)options inView:(NSView *)view;

@end
